var InfiniteScroller = InfiniteScroller || {};

//loading the game assets
InfiniteScroller.Preload = function(){};

InfiniteScroller.Preload.prototype = {
  preload: function() {
    //show loading screen
    this.preloadBar = this.add.sprite(this.game.world.centerX, this.game.world.centerY, 'preloadbar');
    this.preloadBar.anchor.setTo(0.5);
    this.preloadBar.scale.setTo(3);
    this.load.setPreloadSprite(this.preloadBar);

    //load game assets
    //Images
    this.load.spritesheet('player', 'assets/images/Player.png', 85,98,17);
    this.load.image('sky', 'assets/images/Sky.png')
    this.load.image('nearBackground','assets/images/NearBackground.png');
    this.load.image('farBackground','assets/images/FarBackground.png');
    this.load.image('groundTile', 'assets/images/groundTile.png');
    this.load.image('wall', 'assets/images/wall.png');
    this.load.image('shadow', 'assets/images/Shadow.png');
    this.load.image('breakable', 'assets/images/Box.png');
    //Audio
    this.load.audio('music1', ['assets/audio/music.ogg', 'assets/audio/music.mp3']);
	this.load.audio('music2', ['assets/audio/music2.ogg', 'assets/audio/music2.mp3']);
	this.load.audio('music3', ['assets/audio/music3.ogg', 'assets/audio/music3.mp3']);
	this.load.audio('music4', ['assets/audio/music4.ogg', 'assets/audio/music4.mp3']);
    this.load.audio('boxBreak', ['assets/audio/boxBreak.ogg', 'assets/audio/boxBreak.mp3']);
    this.load.audio('youDied', ['assets/audio/youDied.ogg', 'assets/audio/youDied.mp3']);
    this.load.audio('coin', ['assets/audio/coin.ogg', 'assets/audio/coin.mp3']);
	this.load.audio('slideSound', ['assets/audio/slideSound.ogg', 'assets/audio/slideSound.mp3']);
	this.load.audio('doubleSound', ['assets/audio/doubleSound.ogg', 'assets/audio/doubleSound.mp3']);
	this.load.audio('punchSound', ['assets/audio/punchSound.ogg', 'assets/audio/punchSound.mp3']);
  },
  create: function() {
    this.state.start('Game');
  }
};